local triggered = false
local baitPos = vector3(-5246.0, -3465.5, -21.8)
local pokerBlipCoords = vector3(-5228.0, -3478.0, 76.0)
local promptPos = vector3(-5228.0, -3478.0, 76.0)
local radius = 10.0
local showPromptRadius = 1.5
local volume = 0.0
local maxVolume = 1.0
local fadeSpeed = 0.02
local blip = nil
local prompt = nil
local playingPoker = false

local t = {}

function createPokerPrompt()
  local str = CreateVarString(10, "LITERAL_STRING", "Play Poker")
  prompt = PromptRegisterBegin()
  PromptSetControlAction(prompt, 0xCEFD9220) -- "E" key
  PromptSetText(prompt, str)
  PromptSetEnabled(prompt, true)
  PromptSetVisible(prompt, true)
  PromptSetHoldMode(prompt, false)
  PromptSetGroup(prompt, GetHashKey("GROUP_POKER"))
  PromptRegisterEnd(prompt)
end

function t.OnInit()
  -- Create Poker Table Blip
  blip = N_0x554d9d53f696d002(1664425300, pokerBlipCoords)
  SetBlipSprite(blip, 119)
  SetBlipNameFromPlayerString(blip, CreateVarString(10, "LITERAL_STRING", "Poker Table"))
  SetBlipScale(blip, 0.8)
  SetBlipCategory(blip, 2)

  -- Create Prompt
  createPokerPrompt()
end

function t.OnTick()
  local player = PlayerPedId()
  local pos = GetEntityCoords(player)

  -- Ambush trigger and music fade-in
  if not triggered and #(pos - baitPos) < radius then
    StartAudioScene("MUSIC_SCENE")
    SetAudioSceneVariable("MUSIC_SCENE", "Volume", volume)
    TriggerMusicEvent("BENEDICT_AMBUSH_THEME")
    triggered = true
  end

  if triggered and volume < maxVolume then
    volume = math.min(volume + fadeSpeed, maxVolume)
    SetAudioSceneVariable("MUSIC_SCENE", "Volume", volume)
  end

  -- Poker prompt logic
  if #(pos - promptPos) < showPromptRadius then
    PromptSetEnabled(prompt, true)
    PromptSetVisible(prompt, true)

    if PromptHasStandardInputJustBeenPressed(prompt) and not playingPoker then
      playingPoker = true
      TaskStartScenarioAtPosition(player, "WORLD_HUMAN_POKER_PLAYER", promptPos.x, promptPos.y, promptPos.z, 180.0, 0, true, false)
    end
  else
    PromptSetEnabled(prompt, false)
    PromptSetVisible(prompt, false)
  end
end

function t.OnStop()
  if blip then
    RemoveBlip(blip)
  end
end

return t
